# -*- coding: UTF-8 -*-
import traceback
import os

def execute(devObj):
    '''
    @summary: 收集设备上config.zip文件
    '''
    try:
        
        #获取热补丁版本
        ssh = devObj.get("ssh")
        cmd = 'sudo /opt/inspect/inspect_entry.sh getsphversion'
        ret_msg = ssh.execCmd(cmd)
        ret_msgs = [line.strip() for line in ret_msg.splitlines()]
        sph_ver = ret_msgs[1]
        
        #为每套设备创建文件存放文件夹
        tmpDataDir = devObj.get("tmpDataDir")
        devIp = py_java_env.get("devInfo").getIp()
        #IPV6替换:为.否则创建文件夹失败
        devIp = str(devIp).replace(":", ".")                               
        devSN = py_java_env.get("devInfo").getDeviceSerialNumber()
        localFileDir = tmpDataDir + os.path.sep + "data" + os.path.sep + "config" + os.path.sep + devIp + "_" + devSN
        if not os.path.exists(localFileDir):
            os.makedirs(localFileDir)
                
        #触发设备收集
        ssh = devObj.get("ssh")
        cmd = "sudo /opt/inspect/inspect_entry.sh inspectcollect"
        iRet = ssh.execCmdNoLogTimout(cmd, 5*60)
        
        #下载文件
        remoteFile = "/var/log/inspect_collect/Config.zip"
        sftp = devObj.get("sftp")
        sftp.getFile(remoteFile, localFileDir, None)
        
        #删除设备上文件
        deleteFile(ssh)
        
        return ("", dict(flag = True, des = "", sphVer = sph_ver))

    except:
        PY_LOGGER.error("Failed to collect file, because %s" % str(traceback.format_exc()))
        #后台收集，忽略失败
        return ("", dict(flag = True, des = "", sphVer = ""))
        
def deleteFile(ssh):
    '''
    #删除阵列端数据
    '''
    try:
        deletecmd = "rm -f /var/log/inspect_collect/Config.zip"
        ssh.execCmd(deletecmd)
    except:
        PY_LOGGER.error("deleteFile failed")


